﻿using System;
using System.IO;
using System.Runtime.InteropServices;

namespace UsingPInvoke
{
    class Tester
    {

        // Zadeklarowanie funkcji Win API, którą chcemy wywoływać 
        // przy użyciu mechanizmu P/Invoke
        [DllImport("kernel32.dll", EntryPoint = "MoveFile",
            ExactSpelling = false, CharSet = CharSet.Unicode,
            SetLastError = true)]
        static extern bool MoveFile(
            string sourceFile, string destinationFile);

        public static void Main()
        {
            // Utworzenie obiektu naszej klasy i uruchomienie go
            Tester t = new Tester();
            string theDirectory = @"c:\test\media";
            DirectoryInfo dir =
                new DirectoryInfo(theDirectory);
            t.ExploreDirectory(dir);
        }

        // W wywołaniu funkcji należy określić katalog.
        private void ExploreDirectory(DirectoryInfo dir)
        {

            // Utworzenie nowego katalogu
            string newDirectory = "newTest";
            DirectoryInfo newSubDir =
                dir.CreateSubdirectory(newDirectory);

            // Pobranie plików z katalogu i skopiowanie 
            // ich do innego katalogu
            FileInfo[] filesInDir = dir.GetFiles();
            foreach (FileInfo file in filesInDir)
            {
                string fullName = newSubDir.FullName +
                "\\" + file.Name;
                file.CopyTo(fullName);
                Console.WriteLine("{0} copied to newTest",
                file.FullName);
            }

            // Pobranie kolekcji skopiowanych plików
            filesInDir = newSubDir.GetFiles();

            // Usunięcie niektórych plików i zmiana nazwy innych
            int counter = 0;
            foreach (FileInfo file in filesInDir)
            {
                string fullName = file.FullName;

                if (counter++ % 2 == 0)
                {
                    // Wywołanie funkcji Win API przy użyciu P/Invoke
                    Tester.MoveFile(fullName, fullName + ".bak");
                    Console.WriteLine("Nazwę pliku {0} zmieniono na {1}.",
                                      fullName, file.FullName);
                }
                else
                {
                    file.Delete();
                    Console.WriteLine("Usunięto plik {0}.", fullName);
                }
            }

            // Usunięcie podkatalogu
            newSubDir.Delete(true);
        }
    }
}